#include <bits/stdc++.h>
using namespace std;
int short_input_int() {
    int n_short_input_int;
    cin >> n_short_input_int;
    return n_short_input_int;
}
char short_input_char() {
    char n_short_input_char;
    cin >> ws;
    cin.get(n_short_input_char);
    return n_short_input_char;
}
string short_input_string_line() {
    string n_short_input_string;
    getline(cin, n_short_input_string);
    return n_short_input_string;
}
string short_input_string_word() {
    string n_short_input_string;
    cin >> n_short_input_string;
    return n_short_input_string;
}
// 十进制转二进制 (使用整数运算避免浮点精度问题)
int Decimal_to_Binary(int decimal) {
	if (decimal == 0) return 0; // 特殊情况处理
	int binary = 0;
	int base = 1; // 代替 pow(10, i)，初始为 10^0
	while (decimal > 0) {
		binary += (decimal % 2) * base; // 加上当前位的值
		decimal /= 2; // 十进制数右移
		base *= 10; // 权重左移 (个位->十位->百位...)
	}
	return binary;
}
// 二进制转十进制 (修正位序并使用位运算)
int Binary_to_Decimal(const string& binary) {
	int decimal = 0;
	int len = binary.length();
	// 从字符串的最后一个字符（二进制最低位）开始向前遍历
	for (int i = 0; i < len; i++) {
		if (binary[len - 1 - i] == '1') {
			// 使用位运算 1 << i (等价于 pow(2, i)) 代替 math.h 中的 pow
			decimal += (1 << i);
		}
	}
	return decimal;
}
void encryption_word_of_ASCII() {
	cout << "请输入加密导向（‘+’为正向或‘-’负向，再输入数字确定数字，be like“-3”）:";
	const char S_A_S = short_input_char();
	const int T_A_A_S = short_input_int();
	// 【修改点】在 getline 前强制清理输入缓冲区，防止读取到上一次输入留下的 '\n'
	cin.ignore(numeric_limits<streamsize>::max(), '\n');
	cout << "请输入加密要的文字: ";
	string a = short_input_string_line();
	cout << "V V V" << endl;
	for (size_t i = 0; i < a.size(); i++) {
		if (S_A_S == '-') cout << Decimal_to_Binary(a[i] - T_A_A_S) << ' ';
		else if (S_A_S == '+') cout << Decimal_to_Binary(a[i] + T_A_A_S) << ' ';
		else {
			cout << "输入格式错误。" << endl;
			return;
		}
	}
	cout << endl;
}
void decrypt_word_of_ASCII() {
	cout << "请输入加密后的代码 (用空格分隔，输完后回车结束):" << endl;
	cin.ignore(numeric_limits<streamsize>::max(), '\n');
	// 【修改点1】先读取一整行
	string line;
	getline(cin, line);
	// 【修改点2】使用 stringstream 解析这一行，解决了死循环问题
	istringstream iss(line);
	vector<int> a;
	string binary;
	// 只要还能从行中提取出单词，就继续循环
	while (iss >> binary) a.push_back(Binary_to_Decimal(binary));
	cout << "请输入加密导向（‘+’为正向或‘-’负向，再输入数字确定数字，be like“-3”）: ";
	// 这里同样需要清理，因为上面的 getline 已经读完了代码行，但可能需要为下一次 char 读取做准备
	// (根据实际交互情况，此处可视情况保留或删除，通常 getline 后缓冲区是干净的)
	const char S_A_S = short_input_char();
	const int T_A_S = short_input_int();
	for (size_t i = 0; i < a.size(); i++) {
		char c = static_cast<char>(a[i]); // 显式类型转换
		if (S_A_S == '-') c += T_A_S;
		else if (S_A_S == '+') c -= T_A_S;
		else {
			cout << "输入格式错误。" << endl;
			return;
		}
		cout << c;
	}
	cout << endl;
}
int main() {
    cout << "欢迎来到HGN的加密程序！" << endl
         << "你可以输入‘加密’、‘解密’或‘退出。’" << endl;
    string input;
    while (input != "退出") {
        input = short_input_string_word();
        if (input == "加密") encryption_word_of_ASCII();
        else if (input == "解密") decrypt_word_of_ASCII();
        cout << "你可以继续输入‘加密’、‘解密’或‘退出’。" << endl;
    }
    cout << "再见~" << endl;
    cout << "按任意一个按键以关闭。" << endl;
    char a;
	cin >> a;
    return 0;
}
